unit UPizzaBD;

interface

uses
  System.Drawing, System.Collections, System.ComponentModel,
  System.Windows.Forms, System.Data, ZedGraph, System.Globalization,
  Borland.Data.Provider;

type
  TFrmPizzaBD = class(System.Windows.Forms.Form)
  {$REGION 'Designer Managed Code'}
  strict private
    /// <summary>
    /// Required designer variable.
    /// </summary>
    Components: System.ComponentModel.Container;
    ZedGraphControl1: ZedGraph.ZedGraphControl;
    /// <summary>
    /// Required method for Designer support - do not modify
    /// the contents of this method with the code editor.
    /// </summary>
    procedure InitializeComponent;
    procedure TFrmPizzaBD_Load(sender: System.Object; e: System.EventArgs);
  {$ENDREGION}
  strict protected
    /// <summary>
    /// Clean up any resources being used.
    /// </summary>
    procedure Dispose(Disposing: Boolean); override;
  private
    { Private Declarations }
  public
    constructor Create;
  end;

  [assembly: RuntimeRequiredAttribute(TypeOf(TFrmPizzaBD))]

implementation

uses UDM;

{$AUTOBOX ON}

{$REGION 'Windows Form Designer generated code'}
/// <summary>
/// Required method for Designer support -- do not modify
/// the contents of this method with the code editor.
/// </summary>
procedure TFrmPizzaBD.InitializeComponent;
begin
  Self.ZedGraphControl1 := ZedGraph.ZedGraphControl.Create;
  Self.SuspendLayout;
  // 
  // ZedGraphControl1
  // 
  Self.ZedGraphControl1.Anchor := (System.Windows.Forms.AnchorStyles((((System.Windows.Forms.AnchorStyles.Top 
    or System.Windows.Forms.AnchorStyles.Bottom) or System.Windows.Forms.AnchorStyles.Left) 
    or System.Windows.Forms.AnchorStyles.Right)));
  Self.ZedGraphControl1.CultureInfo := System.Globalization.CultureInfo.Create('p' +
    't-BR');
  Self.ZedGraphControl1.IsAutoScrollRange := False;
  Self.ZedGraphControl1.IsEnableHPan := True;
  Self.ZedGraphControl1.IsEnableVPan := True;
  Self.ZedGraphControl1.IsEnableZoom := True;
  Self.ZedGraphControl1.IsScrollY2 := False;
  Self.ZedGraphControl1.IsShowContextMenu := True;
  Self.ZedGraphControl1.IsShowHScrollBar := False;
  Self.ZedGraphControl1.IsShowPointValues := False;
  Self.ZedGraphControl1.IsShowVScrollBar := False;
  Self.ZedGraphControl1.IsZoomOnMouseCenter := False;
  Self.ZedGraphControl1.Location := System.Drawing.Point.Create(8, 16);
  Self.ZedGraphControl1.Name := 'ZedGraphControl1';
  Self.ZedGraphControl1.PanButtons := System.Windows.Forms.MouseButtons.Left;
  Self.ZedGraphControl1.PanButtons2 := System.Windows.Forms.MouseButtons.Middle;
  Self.ZedGraphControl1.PanModifierKeys2 := System.Windows.Forms.Keys.None;
  Self.ZedGraphControl1.PointDateFormat := 'g';
  Self.ZedGraphControl1.PointValueFormat := 'G';
  Self.ZedGraphControl1.ScrollMaxX := 0;
  Self.ZedGraphControl1.ScrollMaxY := 0;
  Self.ZedGraphControl1.ScrollMaxY2 := 0;
  Self.ZedGraphControl1.ScrollMinX := 0;
  Self.ZedGraphControl1.ScrollMinY := 0;
  Self.ZedGraphControl1.ScrollMinY2 := 0;
  Self.ZedGraphControl1.Size := System.Drawing.Size.Create(608, 296);
  Self.ZedGraphControl1.TabIndex := 0;
  Self.ZedGraphControl1.ZoomButtons := System.Windows.Forms.MouseButtons.Left;
  Self.ZedGraphControl1.ZoomButtons2 := System.Windows.Forms.MouseButtons.None;
  Self.ZedGraphControl1.ZoomModifierKeys := System.Windows.Forms.Keys.None;
  Self.ZedGraphControl1.ZoomModifierKeys2 := System.Windows.Forms.Keys.None;
  Self.ZedGraphControl1.ZoomStepFraction := 0.100000001490116;
  // 
  // TFrmPizzaBD
  // 
  Self.AutoScaleBaseSize := System.Drawing.Size.Create(5, 13);
  Self.ClientSize := System.Drawing.Size.Create(632, 326);
  Self.Controls.Add(Self.ZedGraphControl1);
  Self.Name := 'TFrmPizzaBD';
  Self.ShowInTaskbar := False;
  Self.StartPosition := System.Windows.Forms.FormStartPosition.CenterScreen;
  Self.Text := 'WinForm';
  Self.WindowState := System.Windows.Forms.FormWindowState.Maximized;
  Include(Self.Load, Self.TFrmPizzaBD_Load);
  Self.ResumeLayout(False);
end;
{$ENDREGION}

procedure TFrmPizzaBD.Dispose(Disposing: Boolean);
begin
  if Disposing then
  begin
    if Components <> nil then
      Components.Dispose();
  end;
  inherited Dispose(Disposing);
end;

constructor TFrmPizzaBD.Create;
begin
  inherited Create;
  //
  // Required for Windows Form Designer support
  //
  InitializeComponent;
  //
  // TODO: Add any constructor code after InitializeComponent call
  //
end;

procedure TFrmPizzaBD.TFrmPizzaBD_Load(sender: System.Object; e: System.EventArgs);
var
  fatia: PieItem;
  fatias: array of PieItem;
  //includa unit Borland.Data.Provider
  dr: BdpDataReader;
  populacao: array of Double;
  pais: array of String;
  i: integer;

begin
  //todo o cdigo j foi comentado em outros exemplos
  ZedGraphControl1.GraphPane.Title := 'Populao por Pas';
  ZedGraphControl1.GraphPane.XAxis.IsVisible := false;
  ZedGraphControl1.GraphPane.YAxis.IsVisible := false;

  dm.bdpCommand1.Close;
  dm.bdpCommand1.CommandText:= 'select name, population from country';
  dr:= dm.bdpCommand1.ExecuteReader;
  while dr.Read do
  begin
    SetLength(populacao, i+1);
    SetLength(pais, i+1);

    populacao[i]:= System.Convert.ToDouble(dr['population']);
    pais[i]:= dr['name'].ToString;
    inc(i);
  end;
  dm.BdpCommand1.close;

  fatias:= ZedGraphControl1.GraphPane.AddPieSlices(populacao, pais);
  for fatia in fatias  do
  begin
    fatia.Displacement:= 0.04;
    fatia.LabelType:= PieLabelType.Name_Value;
  end;

  ZedGraphControl1.GraphPane.XAxis.&Type := AxisType.Text;
  ZedGraphControl1.GraphPane.AxisFill := Fill.Create(Color.White, Color.LightBlue, 180);
  ZedGraphControl1.GraphPane.PaneFill := Fill.Create(Color.White);
  ZedGraphControl1.GraphPane.Legend.Position := LegendPos.Top;
end;

end.
